package gov.va.med.mhv.usermgmt.main.service.impl;


import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.usermgmt.converter.HealthCareProviderConverter;
import gov.va.med.mhv.usermgmt.data.model.HealthCareProvider;
import gov.va.med.mhv.usermgmt.data.repository.HealthCareProviderRepository;
import gov.va.med.mhv.usermgmt.service.HealthCareProviderService;

@Component
public class HealthCareProviderServiceImpl implements HealthCareProviderService {
	
	protected static Logger log = LogManager.getLogger(HealthCareProviderServiceImpl.class);
	
	@Autowired
	private HealthCareProviderRepository healthCareProviderRepository;
	
	private HealthCareProviderConverter converter = new HealthCareProviderConverter();
//	private EmergencyContactValidator validator = new EmergencyContactValidator();

	@Override
	public void saveHealthCareProvider(HealthCareProviderDTO healthCareProviderDto,
			ResponseUtil response) {
		if( response.getValidationErrors() == null ) {
			response.setValidationErrors(new LinkedHashMap<String,String>());
		}
//		validator.fieldValidation(response, healthCareProviderDto);
		HealthCareProvider e = converter.convertTo(healthCareProviderDto);
		if( response.getValidationErrors() != null && response.getValidationErrors().isEmpty() ) {
			healthCareProviderRepository.save(e);
			response.setFailure(false);
			response.setSuccess(true);
		} else {
			response.setFailure(true);
			response.setSuccess(false);
			return;
		}
	}

	@Override
	public void delete(Long providerId, ResponseUtil response) {
		HealthCareProvider e = healthCareProviderRepository.findByHealthCareProviderId(providerId);
		if( e != null ) {
			healthCareProviderRepository.delete(e);
			response.setSuccess(true);
		} else {
			response.getValidationErrors().put("DELETE_ERROR", "Entity to delete not found.");
			response.setSuccess(false);
		}
	}

	@Override
	public HealthCareProviderDTO findByPrimaryKey(
			HealthCareProviderDTO healthCareProvider) {

		HealthCareProvider ec = healthCareProviderRepository.findByHealthCareProviderId(healthCareProvider.getHealthCareProviderId());
		HealthCareProviderDTO ecDto = converter.convertFrom(ec);
		return ecDto;
	}

//	@Override
	public ResponseUtil findResponseByPrimaryKey(HealthCareProviderDTO healthCareProvider) {
		HealthCareProviderDTO ecDto = findByPrimaryKey(healthCareProvider);
		
		ResponseUtil response = new ResponseUtil();
		response.setPojoObject(ecDto);
		response.setSuccess(true);
		return response;
	}

	@Override
	public List<HealthCareProviderDTO> findByUserProfileId(Long id) {
		List<HealthCareProvider> list = healthCareProviderRepository.findByUserProfileId(id);
		List<HealthCareProviderDTO> dtoList = new ArrayList<HealthCareProviderDTO>();
		if( list != null && list.size() > 0 ) {
			for( HealthCareProvider ec : list ) {
				HealthCareProviderDTO eDto = converter.convertFrom(ec);
				dtoList.add(eDto);
			}
		}
		
		return dtoList;
	}

	@Override
	public ResponseUtil findResponseByUserProfileId(Long id) {
		// TODO Auto-generated method stub
		ResponseUtil response = new ResponseUtil();
		List<HealthCareProviderDTO> list = findByUserProfileId(id);
		response.setPojoObject(list);
		response.setSuccess(true);
		return response;
	}

}
